/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common;

import com.tiviacz.travelersbackpack.util.LogHelper;
import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class BackpackManager {
    public static LevelResource BACKPACKS = new LevelResource("backpacks");

    public static void addBackpack(ServerPlayer player, ItemStack stack) {
        try {
            LocalDateTime deathTime = LocalDateTime.now();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd.MM.yyyy-HH.mm.ss");
            String formattedDeathTime = deathTime.format(formatter);
            String datedBackpackName = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString().replace(":", ".") + "_" + formattedDeathTime + ".dat";
            File backpackFile = BackpackManager.getBackpackFile(player, datedBackpackName);
            backpackFile.getParentFile().mkdirs();
            NbtIo.m_128955_((CompoundTag)stack.m_41739_(new CompoundTag()), (File)backpackFile);
            LogHelper.info("Created new backpack backup file for " + player.m_5446_().getString() + " with unique ID " + datedBackpackName, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Nullable
    public static ItemStack getBackpack(ServerLevel serverLevel, UUID playerUUID, String backpackId) {
        try {
            CompoundTag data = NbtIo.m_128953_((File)BackpackManager.getBackpackFile(serverLevel, playerUUID, backpackId));
            if (data == null) {
                return null;
            }
            return ItemStack.m_41712_((CompoundTag)data);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    public static ItemStack getBackpack(ServerLevel serverLevel, String backpackId) {
        File deathFolder = BackpackManager.getBackpackFolder(serverLevel);
        File[] players = deathFolder.listFiles((dir, name) -> name.matches("^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$"));
        if (players == null) {
            return null;
        }
        for (File f : players) {
            File[] files;
            if (!f.isDirectory() || (files = f.listFiles((dir, name) -> name.equals(backpackId))) == null || files.length <= 0) continue;
            return BackpackManager.getBackpack(serverLevel, UUID.fromString(f.getName()), backpackId);
        }
        return null;
    }

    public static File getBackpackFile(ServerLevel serverLevel, UUID playerUUID, String backpackId) {
        return new File(BackpackManager.getPlayerBackpackFolder(serverLevel, playerUUID), backpackId);
    }

    public static File getBackpackFile(ServerPlayer player, String backpackId) {
        return new File(BackpackManager.getPlayerBackpackFolder(player), backpackId);
    }

    public static File getPlayerBackpackFolder(ServerPlayer player) {
        return BackpackManager.getPlayerBackpackFolder(player.m_284548_(), player.m_20148_());
    }

    public static File getPlayerBackpackFolder(ServerLevel serverLevel, UUID uuid) {
        return new File(BackpackManager.getBackpackFolder(serverLevel), uuid.toString());
    }

    public static File getBackpackFolder(ServerLevel serverLevel) {
        return BackpackManager.getWorldFolder(serverLevel, BACKPACKS);
    }

    public static File getWorldFolder(ServerLevel serverLevel, LevelResource path) {
        return serverLevel.m_7654_().m_129843_(path).toFile();
    }
}

